
//*****************************************************************************
//
//	MEMORY MAP USAGE OF THE 7800
//
//	00-1F		TIA REGISTERS
//	20-3F		MARIA REGISTERS
//	40-FF		ZERO PAGE RAM		<-----------------------\
//	100-13F		SHADOW OF TIA AND MARIA REGISTERS -- USED FOR	|
//			PUSHING ACCUMULATOR ONTO REGISTERS		|
//	140-1FF		RAM (STACK)	<----------\			|
//	200-27F		NOT USED		   |			|
//	280-2FF		PIA PORTS AND TIMERS	   |			|
//	300-17FF	NOT USED		   |			|
//	1800-203F	RAM			   |			|
//	2040-20FF	SHADOW OF ZERO PAGE RAM	   |	<---------------/
//	2100-213F	RAM			   |
//	2140-21FF	SHADOW OF STACK RAM	<--/
//	2200-27FF	RAM
//	2800-3FFF	DUPLICATION OF ADDRESS SPACE 2000-27FF
//	4000-FF7F	UNUSED ADDRESS SPACE
//	FF80-FFF9	RESERVED FOR ENCRYPTION
//	FFFA-FFFF	6502 VECTORS
//

INPTCTRL	=	$01	;INPUT PORT CONTROL ("VBLANK" IN TIA )

//
//	AFTER INITIALIZING SWCHB AS FOLLOWS:
//
//	LDA  #$14
//	STA  CTLSWB
//	LDA  #0
//	STA  SWCHB
//

//	...LEFT AND RIGHT FIRE BUTTONS CAN BE READ FROM THE FOLLOWING 4 LOCATIONS:
//
//			THESE ARE ALSO USED FOR PADDLE INPUT
INPT0		=	$08	;PLAYER 0, RIGHT FIRE BUTTON (D7=1 WHEN PUSHED)
INPT1		=	$09	;PLAYER 0, LEFT FIRE BUTTON  (D7=1 WHEN PUSHED)
INPT2		=	$0A	;PLAYER 1, RIGHT FIRE BUTTON (D7=1 WHEN PUSHED)
INPT3		=	$0B	;PLAYER 1, LEFT FIRE BUTTON  (D7=1 WHEN PUSHED)

//
//	LEFT OR RIGHT FIRE BUTTONS READ FROM THESE LOCATIONS:
//
INPT4		=	$0C	;PLAYER 0 FIRE BUTTON INPUT (D7=0 WHEN PUSHED)
INPT5		=	$0D	;PLAYER 1 FIRE BUTTON INPUT (D7=0 WHEN PUSHED)

//
AUDC0		=	$15	;AUDIO CONTROL CHANNEL 0
AUDC1		=	$16	;AUDIO CONTROL CHANNEL 1
AUDF0		=	$17	;AUDIO FR=ENCY CHANNEL 0
AUDF1		=	$18	;AUDIO FR=ENCY CHANNEL 1
AUDV0		=	$19	;AUDIO VOLUME CHANNEL 0
AUDV1		=	$1A	;AUDIO VOLUME CHANNEL 1

//*****************************************************************************

BACKGRND	=	$20	;BACKGROUND COLOR
P0C1		=	$21	;PALETTE 0 - COLOR 1
P0C2		=	$22	;	   - COLOR 2
P0C3		=	$23	;	   - COLOR 3
WSYNC		=	$24	;WAIT FOR SYNC
P1C1		=	$25	;PALETTE 1 - COLOR 1
P1C2		=	$26	;	   - COLOR 2
P1C3		=	$27	;	   - COLOR 3
MSTAT		=	$28	;MARIA STATUS
P2C1		=	$29	;PALETTE 2 - COLOR 1
P2C2		=	$2A	;	   - COLOR 2
P2C3		=	$2B	;	   - COLOR 3
DPPH		=	$2C	;DISPLAY LIST LIST POINT HIGH BYTE
P3C1		=	$2D	;PALETTE 3 - COLOR 1
P3C2		=	$2E	;	   - COLOR 2
P3C3		=	$2F	;	   - COLOR 3
DPPL		=	$30	;DISPLAY LIST LIST POINT LOW BYTE
P4C1		=	$31	;PALETTE 4 - COLOR 1
P4C2		=	$32	;	   - COLOR 2
P4C3		=	$33	;	   - COLOR 3
CHBASE		=	$34	;CHARACTER BASE ADDRESS
P5C1		=	$35	;PALETTE 5 - COLOR 1
P5C2		=	$36	;	   - COLOR 2
P5C3		=	$37	;	   - COLOR 3
OFFSET		=	$38	;FOR FUTURE EXPANSION - STORE ZER0 HERE
P6C1		=	$39	;PALETTE 6 - COLOR 1
P6C2		=	$3A	;	   - COLOR 2
P6C3		=	$3B	;	   - COLOR 3
CTRL		=	$3C	;MARIA CONTROL REGISTER
P7C1		=	$3D	;PALETTE 7 - COLOR 1
P7C2		=	$3E	;	   - COLOR 2
P7C3		=	$3F	;	   - COLOR 3

//
//	PIA AND TIMER (6532) LOCATIONS
//
SWCHA		=	$280	;LEFT & RIGHT JOYSTICKS
//
//	LEFT RITE
//	7654 3210	;BIT POSITION (=0 IF SWITCH IS CLOSED)
//	---- ----
//	RLDU RLDU	;RIGHT/LEFT/DOWN/UP
//
CTLSWA		=	$281	;SWCHA DATA DIRECTION (0=INPUT)
SWACNT		=	$281	;synonym for CTLSWA

SWCHB		=	$282    ;CONSOLE SWITCHES
//
//	D7-RITE DIFFICULTY
//	D6-LEFT DIFFICULTY
//	D5/D4 NOT USED
//	D3-PAUSE
//	D2-NOT USED
//	D1-GAME SELECT
//	D0-GAME RESET
//
CTLSWB		=	$283	;SWCHB DATA DIRECTION (0=INPUT)
SWBCNT		=	$283	;synonym for CTLSWB

INTIM		=	$284	;INTERVAL TIMER READ
TIM1T		=	$294	;SET 1    CLK INTERVAL (838   NSEC/INTERVAL)
TIM8T		=	$295	;SET 8    CLK INTERVAL (6.7   USEC/INTERVAL)
TIM64T		=	$296	;SET 64   CLK INTERVAL (53.6  USEC/INTERVAL)
T1024T		=	$297	;SET 1024 CLK INTERVAL (858.2 USEC/INTERVAL)
//
//
//
//
RESET		=	$01	;bits for consle switches
SELECT		=	$02
PAUSE		=	$08
