/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import org.bluray.media.StreamNotAvailableException;
import org.bluray.media.SubtitleStyleNotAvailableException;
import org.bluray.media.SubtitlingControl;
import org.bluray.media.TextSubtitleNotAvailableException;
import org.bluray.ti.CodingType;
import org.dvb.media.SubtitleAvailableEvent;
import org.dvb.media.SubtitleListener;
import org.dvb.media.SubtitleNotAvailableEvent;
import org.dvb.media.SubtitleNotSelectedEvent;
import org.dvb.media.SubtitleSelectedEvent;
import org.videolan.BDJListeners;
import org.videolan.Libbluray;
import org.videolan.StreamInfo;
import org.videolan.TIClip;
import org.videolan.media.content.playlist.Handler;
import org.videolan.media.content.playlist.StreamControl;

public class SubtitlingControlImpl
extends StreamControl
implements SubtitlingControl {
    private Handler player;
    private BDJListeners listeners = new BDJListeners();

    protected SubtitlingControlImpl(Handler player) {
        this.player = player;
    }

    @Override
    protected StreamInfo[] getStreams() {
        TIClip ci = this.player.getCurrentClipInfo();
        if (ci == null) {
            return null;
        }
        return ci.getPgStreams();
    }

    @Override
    protected String getDefaultLanguage() {
        return this.languageFromInteger(Libbluray.readPSR(17));
    }

    @Override
    public int getCurrentStreamNumber() {
        return Libbluray.readPSR(2) & 0xFFF;
    }

    @Override
    protected void setStreamNumber(int num) {
        Libbluray.writePSR(2, num, 4095);
    }

    @Override
    public boolean isSubtitlingOn() {
        return (Libbluray.readPSR(2) & Integer.MIN_VALUE) != 0;
    }

    @Override
    public boolean setSubtitling(boolean mode) {
        boolean oldMode = (Libbluray.readPSR(2) & Integer.MIN_VALUE) != 0;
        Libbluray.writePSR(2, mode ? Integer.MIN_VALUE : 0, Integer.MIN_VALUE);
        return oldMode;
    }

    @Override
    public void selectSubtitle(int subtitle) throws StreamNotAvailableException {
        this.selectStreamNumber(subtitle);
    }

    @Override
    public boolean isPipSubtitleMode() {
        return (Libbluray.readPSR(2) & 0x40000000) != 0;
    }

    @Override
    public boolean setPipSubtitleMode(boolean mode) {
        boolean oldMode = (Libbluray.readPSR(2) & 0x40000000) != 0;
        Libbluray.writePSR(2, mode ? 0x40000000 : 0, 0x40000000);
        return oldMode;
    }

    @Override
    public void setSubtitleStyle(int style) throws TextSubtitleNotAvailableException, SubtitleStyleNotAvailableException {
        if (style <= 0 || style > 25 && style != 255) {
            throw new SubtitleStyleNotAvailableException();
        }
        if (this.getCurrentSubtitleType() != CodingType.TEXT_SUBTITLE) {
            throw new TextSubtitleNotAvailableException();
        }
        Libbluray.writePSR(12, style);
    }

    @Override
    public CodingType getCurrentSubtitleType() {
        StreamInfo[] streamInfo = this.getStreams();
        if (streamInfo == null) {
            return null;
        }
        int stream = this.getCurrentStreamNumber();
        if (stream <= 0 || stream > streamInfo.length) {
            return null;
        }
        return streamInfo[stream - 1].getCodingType();
    }

    @Override
    public int getSubtitleStyle() throws TextSubtitleNotAvailableException, SubtitleStyleNotAvailableException {
        if (this.getCurrentSubtitleType() != CodingType.TEXT_SUBTITLE) {
            throw new TextSubtitleNotAvailableException();
        }
        int style = Libbluray.readPSR(12);
        if (style <= 0 || style > 25 && style != 255) {
            throw new SubtitleStyleNotAvailableException();
        }
        return style;
    }

    @Override
    public void addSubtitleListener(SubtitleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSubtitleListener(SubtitleListener listener) {
        this.listeners.remove(listener);
    }

    protected void onSubtitleChange(int param) {
        if ((param & Integer.MIN_VALUE) != 0) {
            this.listeners.putCallback(new SubtitleSelectedEvent(this));
        } else {
            this.listeners.putCallback(new SubtitleNotSelectedEvent(this));
        }
    }

    protected void onSubtitleAvailable(boolean param) {
        if (param) {
            this.listeners.putCallback(new SubtitleAvailableEvent(this));
        } else {
            this.listeners.putCallback(new SubtitleNotAvailableEvent(this));
        }
    }
}

