# Icinga Knowledge Base - IWKB000006

## Short Message

The user you are running this command as does not have permission to access the Windows Update ComObject "Microsoft.Update.Session".

## Example Exception

[UNKNOWN]: Icinga Permission Error was thrown: WindowsUpdate

The user you are running this command as does not have permission to access the Windows Update ComObject "Microsoft.Update.Session".

## Reason

This issue is caused by calling [Invoke-IcingaCheckUpdates](https://icinga.com/docs/windows/latest/plugins/doc/plugins/14-Invoke-IcingaCheckUpdates/) over PowerShell Remote execution, with for example [check_by_powershell](https://github.com/Icinga/check_by_powershell).
The Windows COM Object is rejecting every access to these information over remote connections, making it impossible to execute the plugin.

## Solution

Right now there is no solution available for this problem. Microsoft is not allowing to grant permission to these objects over remote connections, which makes it impossible to use them. In addition there is no proper alternative for fetching pending Windows Updates and Hotfixes.

A possible fix which is suggested online is to add a scheduled task, running the command after being triggered by our execution and afterwards fetching the result from the task. This solution requires more research, testing and development.
