[![PowerShell Version](https://img.shields.io/badge/PowerShell-5.1-777BB4?logo=PowerSHell)](https://learn.microsoft.com/en-US/powershell/scripting/install/installing-powershell-on-windows?view=powershell-5.1)
[![GitHub Tag](https://img.shields.io/github/tag/Icinga/icinga-powershell-framework.svg)](https://github.com/Icinga/icinga-powershell-framework/releases/latest)
[![GitHub Issues](https://img.shields.io/github/issues-search?query=repo%3Aicinga%2Ficinga-powershell-framework%20is%3Aopen%20is%3Aissue&label=Issues&color=red
)](https://github.com/Icinga/icinga-powershell-framework/issues)
[![GitHub Pull Requests](https://img.shields.io/github/issues-search?query=repo%3Aicinga%2Ficinga-powershell-framework%20is%3Aopen%20is%3Apr&label=Pull%20Requests&color=green
)](https://github.com/Icinga/icinga-powershell-framework/pulls)

Icinga PowerShell Framework
==============

The Icinga PowerShell Framework provides a wide range of configuration and check possibilities to ensure an easy integration and full monitoring of Windows environments.
Each single chapter of this documentation will describe parts of the module and the possibilities.

Before you continue, please take a look at the [Installation Guide](doc/110-Installation/01-Getting-Started.md)

Documentation
-------------

Please take a look at the following content to get to know the possibilities of the module including examples on how to use it.

* [Introduction](doc/000-Introduction.md)
* [Installation Guide](doc/110-Installation/01-Getting-Started.md)
* [Repository Management](doc/120-Repository-Manager)
* [JEA](doc/130-JEA)
* [Icinga Integration](doc/200-Icinga-Integration/)
* [Framework Usage Examples](doc/frameworkusage)
* [Icinga PowerShell Framework as Service](doc/110-Installation/05-Background-Daemons.md)
* [Knowledge Base](doc/300-Knowledge-Base.md)
* [Changelog](doc/100-General/10-Changelog.md)

Developer Guide
------------

If you wish to extend the Framework by yourself or write custom plugins for your environment, please have a look at the [Developer Guide](doc/900-Developer-Guide) for detailed explanations of functions and code examples.

Contributing
------------

The Icinga PowerShell Framework is an Open Source project and lives from your contributions. No matter whether these are feature requests, issues, translations, documentation or code.

* Please check whether a related issue alredy exists on our [Issue Tracker](https://github.com/Icinga/icinga-powershell-framework/issues)
* Send a [Pull Request](https://github.com/Icinga/icinga-powershell-framework/pulls)
* The master branch shall never be corrupt!
